<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ChatController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

// Main chat interface
Route::get('/', [ChatController::class, 'index'])->name('chat.index');

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
*/

Route::prefix('api')->group(function () {
    // Chat endpoints
    Route::post('/chat/send', [ChatController::class, 'sendMessage'])->name('chat.send');
    Route::post('/chat/reset', [ChatController::class, 'resetConversation'])->name('chat.reset');
    Route::get('/chat/quick-replies', [ChatController::class, 'getQuickReplies'])->name('chat.quick-replies');
});