<?php
require_once( "db.php" );
//require_once( "useSingleton.php" );
/**
 * Methods for database handling.
 */
class Login extends Db  {

   
    const BCRYPT_COST = 14;
	
	public $username;
	public $password;
	public $role;
	public $exist;
	 
	 
	 public function __construct() {

   }
	 
	 
    

    /**
     * Gets given users password.
     *
     * @param $username The username to get the password of.
     * @return The password of the given user.
     */
    public function getUsersPassword($username) {
		$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
        $sql = 'SELECT password
                FROM   login
                WHERE  username = :username';

        $statement = $MySQLiconn->prepare($sql);
        $statement->bindValue(':username', $username);

        $statement->execute();
        $row = $statement->fetch(PDO::FETCH_ASSOC);
        $this->password = $row['password'];

       parent::DisConnect( $MySQLiconn);

        return $this->password;
    }

    /**
     * Creates a new user.
     *
     * @param $username The username to create.
     * @param $password The password of the user.
     */
    public function createLogin($staffno,$password,$role,$email,$textcode,$password2) {
	   $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();	
	   
	 try{
	 
       $sql = "INSERT INTO login (staffno,password,role,email,textcode,password2)
                VALUES (:staffno, :password, :role, :email, :textcode, :password2)";
					

       $options = array('cost' => self::BCRYPT_COST);
        $derivedPassword = password_hash($password, PASSWORD_BCRYPT, $options);
       // $derivedTexcode = md5(uniqid(rand())); 
        $statement = $MySQLiconn->prepare($sql);
	
        $statement->bindValue(':staffno',$staffno, PDO::PARAM_STR );
		
        $statement->bindValue(":password", $derivedPassword, PDO::PARAM_STR);
        $statement->bindValue(":role", $role,  PDO::PARAM_STR);
		$statement->bindValue(":email", $email , PDO::PARAM_STR);
		$statement->bindValue(":textcode", $textcode , PDO::PARAM_STR);
			$statement->bindValue(":password2", $password2 , PDO::PARAM_STR);
        $statement->execute();
		
		
		parent::DisConnect( $MySQLiconn);
	  }

        catch(Exception $e){
			echo "oops! ".$e->getMessage(); 
			
			}   
    }
	
	
	
	
	public function countAll(){
	$instance = parent::getInstance();
		//$instance = new DBAccess();
       $MySQLiconn  = $instance->getConnection();	
 
   $sql = "SELECT * from members";
				$statement = $MySQLiconn->prepare($sql);
    $statement->execute();
 
    $num = $statement->rowCount();
 
    return $num;
	parent::DisConnect( $MySQLiconn);
}







public function getUsersPassword2($username) {
		$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
        $sql = 'SELECT *
                FROM   login
                WHERE  username = :username';

        $statement = $MySQLiconn->prepare($sql);
        $statement->bindValue(':username', $username);

        $statement->execute();
		$row = $statement->fetch(PDO::FETCH_ASSOC);
	
	   $this->role = $row['role'];
 
    return $this->role;
        
      
		 parent::DisConnect( $MySQLiconn);
		
    }

   public function getPassword(){
	   return $this->password ;
	   }
	   
	 public function getRole(){
	   return $this->role ;
	   }   
	
	
	
	 public function updateLoginDetails($staffno,$password,$password2) {
	   $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();	
	   
	 try{
	 
    //   $sql = "INSERT INTO login (staffno,password,role,email,textcode,password2)
              //  VALUES (:staffno, :password, :role, :email, :textcode, :password2)";
			  
			  $sql = "UPDATE login SET password = :password, password2 = :password2 WHERE staffno = :staffno";
					

       $options = array('cost' => self::BCRYPT_COST);
        $derivedPassword = password_hash($password, PASSWORD_BCRYPT, $options);
       // $derivedTexcode = md5(uniqid(rand())); 
        $statement = $MySQLiconn->prepare($sql);
	
        $statement->bindValue(':staffno',$staffno, PDO::PARAM_STR );
		
        $statement->bindValue(":password", $derivedPassword, PDO::PARAM_STR);
        
		
			$statement->bindValue(":password2", $password2 , PDO::PARAM_STR);
        $statement->execute();
		
		
		parent::DisConnect( $MySQLiconn);
	  }

        catch(Exception $e){
			echo "oops! ".$e->getMessage(); 
			
			}   
    }
	
	
	
	 public function updateSubjectLoginDetails($staffno,$password,$password2) {
	   $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();	
	   
	 try{
	 
    //   $sql = "INSERT INTO login (staffno,password,role,email,textcode,password2)
              //  VALUES (:staffno, :password, :role, :email, :textcode, :password2)";
			  
			  $sql = "UPDATE subjectlogin SET password = :password, password2 = :password2 WHERE staffno = :staffno";
					

       $options = array('cost' => self::BCRYPT_COST);
        $derivedPassword = password_hash($password, PASSWORD_BCRYPT, $options);
       // $derivedTexcode = md5(uniqid(rand())); 
        $statement = $MySQLiconn->prepare($sql);
	
        $statement->bindValue(':staffno',$staffno, PDO::PARAM_STR );
		
        $statement->bindValue(":password", $derivedPassword, PDO::PARAM_STR);
        
		
			$statement->bindValue(":password2", $password2 , PDO::PARAM_STR);
        $statement->execute();
		
		
		parent::DisConnect( $MySQLiconn);
	  }

        catch(Exception $e){
			echo "oops! ".$e->getMessage(); 
			
			}   
    }
	
	
		
      public function getUsersPasswordSubject($staffno) {
		$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
        $sql = 'SELECT password
                FROM   subjectlogin
                WHERE  staffno = :staffno';

        $statement = $MySQLiconn->prepare($sql);
        $statement->bindValue(':staffno', $staffno);

        $statement->execute();
        $row = $statement->fetch(PDO::FETCH_ASSOC);
        $this->password = $row['password'];

       parent::DisConnect( $MySQLiconn);

        return $this->password;
    }
 

  public function getUsersPassword2Subject($staffno) {
		$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
        $sql = 'SELECT *
                FROM   subjectlogin
                WHERE  staffno = :staffno';

        $statement = $MySQLiconn->prepare($sql);
        $statement->bindValue(':staffno', $staffno);

        $statement->execute();
		$row = $statement->fetch(PDO::FETCH_ASSOC);
	
	   $this->role = $row['role'];
 
    return $this->role;
        
      
		 parent::DisConnect( $MySQLiconn);
		
    }



	 public function createSubjectLogin($staffno,$password,$role,$email,$textcode,$password2) {
	   $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();	
	   
	 try{
	 
       $sql = "INSERT INTO subjectlogin (staffno,password,role,email,textcode,password2)
                VALUES (:staffno, :password, :role, :email, :textcode, :password2)";
					

       $options = array('cost' => self::BCRYPT_COST);
        $derivedPassword = password_hash($password, PASSWORD_BCRYPT, $options);
       // $derivedTexcode = md5(uniqid(rand())); 
        $statement = $MySQLiconn->prepare($sql);
	
        $statement->bindValue(':staffno',$staffno, PDO::PARAM_STR );
		
        $statement->bindValue(":password", $derivedPassword, PDO::PARAM_STR);
        $statement->bindValue(":role", $role,  PDO::PARAM_STR);
		$statement->bindValue(":email", $email , PDO::PARAM_STR);
		$statement->bindValue(":textcode", $textcode , PDO::PARAM_STR);
			$statement->bindValue(":password2", $password2 , PDO::PARAM_STR);
        $statement->execute();
		
		
		parent::DisConnect( $MySQLiconn);
	  }

        catch(Exception $e){
		//	echo "oops! ".$e->getMessage(); 
			
			}   
    }
		
	
	
	
	public function checkStaffid($staffno){
	  
	  $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
        $sql = 'SELECT *
                FROM   login
                WHERE  staffno = :staffno';

        $statement = $MySQLiconn->prepare($sql);
        $statement->bindValue(':staffno', $staffno);

        $statement->execute();
		//$row = $statement->fetch(PDO::FETCH_ASSOC);
		
     
	  $num = $statement->rowCount();
	 
 
    return $num;
        
      
		 parent::DisConnect( $MySQLiconn);
	  	
		
		} 	
	
	
	 public function deleteStaffLogin($staffno){
		
		$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
        $sql = 'DELETE 
                FROM   login
                WHERE  staffno = :staffno';

        $statement = $MySQLiconn->prepare($sql);
        $statement->bindValue(':staffno', $staffno);

        $statement->execute();  
		  parent::DisConnect( $MySQLiconn);
		}		
	
	
	public function deleteStaffSubjectLogin($staffno){
		
		$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
        $sql = 'DELETE 
                FROM   subjectlogin
                WHERE  staffno = :staffno';

        $statement = $MySQLiconn->prepare($sql);
        $statement->bindValue(':staffno', $staffno);

        $statement->execute();  
		  parent::DisConnect( $MySQLiconn);
		}	
		
		
	
	public function deleteVerifySubjectLogin($staffno){
		
		$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
        $sql = 'DELETE 
                FROM   verifysubject
                WHERE  staffno = :staffno';

        $statement = $MySQLiconn->prepare($sql);
        $statement->bindValue(':staffno', $staffno);

        $statement->execute();  
		  parent::DisConnect( $MySQLiconn);
		}		
	
	




    public function createLoginExam($username,$password,$role,$name, $increment) {
      $instance = parent::getInstance();	
        $MySQLiconn  = $instance->getConnection();	
      
    try{
    
        $sql = "INSERT INTO login (username,password,role,name, increment)
                 VALUES (:username, :password, :role, :name, :increment)";
           
 
        $options = array('cost' => self::BCRYPT_COST);
         $derivedPassword = password_hash($password, PASSWORD_BCRYPT, $options);
        // $derivedTexcode = md5(uniqid(rand())); 
         $statement = $MySQLiconn->prepare($sql);
   
         $statement->bindValue(':username',$username, PDO::PARAM_STR );
     
         $statement->bindValue(":password", $derivedPassword, PDO::PARAM_STR);
         $statement->bindValue(":role", $role,  PDO::PARAM_STR);
     $statement->bindValue(":name", $name , PDO::PARAM_STR);
     $statement->bindValue(":increment", $increment , PDO::PARAM_STR);
         $statement->execute();
     
     
     parent::DisConnect( $MySQLiconn);
     }
 
         catch(Exception $e){
       echo "oops! ".$e->getMessage(); 
       
       }   
     }
   
   

     public function checkLogin($username){
		
      $instance = parent::getInstance();	
         $MySQLiconn  = $instance->getConnection();
      
          $sql = 'SELECT *
                  FROM   login 
                  WHERE  username = :username';
  
          $statement = $MySQLiconn->prepare($sql);
          $statement->bindValue(':username', $username);
  
          $statement->execute();
      //$row = $statement->fetch(PDO::FETCH_ASSOC);
      
       
      $num = $statement->rowCount();
     
   
      return $num;
          
        
       parent::DisConnect( $MySQLiconn);
      
      
      
      
      }
  
  

      public function getLastStaffUsername(){
		
				$instance = parent::getInstance();	
			   $MySQLiconn  = $instance->getConnection();
				
				$sql = 'SELECT *
						FROM   login ORDER BY increment DESC LIMIT 1
						';
		
				$statement = $MySQLiconn->prepare($sql);
				//$statement->bindValue(':title', $title);
		
				$statement->execute();
				$row = $statement->fetch(PDO::FETCH_ASSOC);
				
			 
			 // $num = $statement->rowCount();
			 
		   $increment = $row['increment'];
			return $increment;
				
			  
				 parent::DisConnect( $MySQLiconn);
				
				
				
				
				}

     
        public function allUsers(){
		
          $instance = parent::getInstance();	
             $MySQLiconn  = $instance->getConnection();
          
              $sql = 'SELECT *
                      FROM   login 
                      ';
      
              $statement = $MySQLiconn->prepare($sql);
             
      
              $statement->execute();
          //$row = $statement->fetch(PDO::FETCH_ASSOC);
          
           
        
         
       
          return $statement;
              
            
           parent::DisConnect( $MySQLiconn);
          
          
          
          
          }
      
      
          public function deleteUserLogin($username){
		
            $instance = parent::getInstance();	
               $MySQLiconn  = $instance->getConnection();
            
                $sql = 'DELETE 
                        FROM   login
                        WHERE  username = :username';
        
                $statement = $MySQLiconn->prepare($sql);
                $statement->bindValue(':username', $username);
        
                $statement->execute();  
              parent::DisConnect( $MySQLiconn);
            }	

        
    
            public function getUserDetails($username) {
              $instance = parent::getInstance();	
                 $MySQLiconn  = $instance->getConnection();
              
                  $sql = 'SELECT *
                          FROM   login
                          WHERE  username = :username';
          
                  $statement = $MySQLiconn->prepare($sql);
                  $statement->bindValue(':username', $username);
          
                  $statement->execute();
                  $row = $statement->fetch(PDO::FETCH_ASSOC);
                  $this->username = $row['username'];
                  $this->role = $row['role'];
                  $this->name = $row['name'];
                 parent::DisConnect( $MySQLiconn);
          
                  return $this->password;
              }


          
              public function updateUser($username,$role,$name) {
                $instance = parent::getInstance();	
                  $MySQLiconn  = $instance->getConnection();	
                
              try{
              
                  $sql = " UPDATE login set name = :name, role = :role WHERE username = :username";
                     
           
                  
                   $statement = $MySQLiconn->prepare($sql);
             
                   $statement->bindValue(':username',$username, PDO::PARAM_STR );
               
                  
                   $statement->bindValue(":role", $role,  PDO::PARAM_STR);
               $statement->bindValue(":name", $name , PDO::PARAM_STR);
            
                   $statement->execute();
               
               
               parent::DisConnect( $MySQLiconn);
               }
           
                   catch(Exception $e){
                 echo "oops! ".$e->getMessage(); 
                 
                 }   
               }



               public function updateStaffLoginDetails($username,$password) {
                $instance = parent::getInstance();	
                  $MySQLiconn  = $instance->getConnection();	
                
              try{
              
               //   $sql = "INSERT INTO login (staffno,password,role,email,textcode,password2)
                         //  VALUES (:staffno, :password, :role, :email, :textcode, :password2)";
                   
                   $sql = "UPDATE login SET password = :password WHERE username = :username";
                     
           
                  $options = array('cost' => self::BCRYPT_COST);
                   $derivedPassword = password_hash($password, PASSWORD_BCRYPT, $options);
                  // $derivedTexcode = md5(uniqid(rand())); 
                   $statement = $MySQLiconn->prepare($sql);
             
                   $statement->bindValue(':username',$username, PDO::PARAM_STR );
               
                   $statement->bindValue(":password", $derivedPassword, PDO::PARAM_STR);
                   
               
                
                   $statement->execute();
               
               
               parent::DisConnect( $MySQLiconn);
               }
           
                   catch(Exception $e){
                 echo "oops! ".$e->getMessage(); 
                 
                 }   
               }
          
           public function deactivateUser($username){
		
            $instance = parent::getInstance();	
               $MySQLiconn  = $instance->getConnection();
            
                $sql = "UPDATE   login set role = 'none'
                        WHERE  username = :username";
        
                $statement = $MySQLiconn->prepare($sql);
                $statement->bindValue(':username', $username);
        
                $statement->execute();  
              parent::DisConnect( $MySQLiconn);
            }   

	
}