<?php
require_once( "dbresult.php" );

class Login extends Dbresult  {

   
  const BCRYPT_COST = 14;

public $username;
public $password;
public $role;
public $exist;
 
 
 public function __construct() {

 }
 
 
  
  
   public function getUserData($staffno) {
        $instance = parent::getInstance();    
        $MySQLiconn = $instance->getConnection();

        $sql = "SELECT password, role FROM login WHERE staffno = :staffno";
        $stmt = $MySQLiconn->prepare($sql);
        $stmt->bindValue(':staffno', $staffno, PDO::PARAM_STR);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        parent::DisConnect($MySQLiconn);

        return $row; // returns ['password'=>..., 'role'=>...]
    }
  
  

  /**
   * Gets given users password.
   *
   * @param $username The username to get the password of.
   * @return The password of the given user.
   */
  public function getUsersPassword($staffno) {
  $instance = parent::getInstance();	
     $MySQLiconn  = $instance->getConnection();
  
      $sql = 'SELECT password
              FROM   login
              WHERE  staffno = :staffno';

      $statement = $MySQLiconn->prepare($sql);
      $statement->bindValue(':staffno', $staffno);

      $statement->execute();
      $row = $statement->fetch(PDO::FETCH_ASSOC);
      $this->password = $row['password'];

     parent::DisConnect( $MySQLiconn);

      return $this->password;
  }

  /**
   * Creates a new user.
   *
   * @param $username The username to create.
   * @param $password The password of the user.
   */
  public function createLogin($staffno,$password,$role,$email,$textcode,$password2) {
   $instance = parent::getInstance();	
     $MySQLiconn  = $instance->getConnection();	
   
 try{
 
     $sql = "INSERT INTO login (staffno,password,role,email,textcode,password2)
              VALUES (:staffno, :password, :role, :email, :textcode, :password2)";
        

     $options = array('cost' => self::BCRYPT_COST);
      $derivedPassword = password_hash($password, PASSWORD_BCRYPT, $options);
     // $derivedTexcode = md5(uniqid(rand())); 
      $statement = $MySQLiconn->prepare($sql);

      $statement->bindValue(':staffno',$staffno, PDO::PARAM_STR );
  
      $statement->bindValue(":password", $derivedPassword, PDO::PARAM_STR);
      $statement->bindValue(":role", $role,  PDO::PARAM_STR);
  $statement->bindValue(":email", $email , PDO::PARAM_STR);
  $statement->bindValue(":textcode", $textcode , PDO::PARAM_STR);
    $statement->bindValue(":password2", $password2 , PDO::PARAM_STR);
      $statement->execute();
  
  
  parent::DisConnect( $MySQLiconn);
  }

      catch(Exception $e){
    echo "oops! ".$e->getMessage(); 
    
    }   
  }




public function countAll(){
$instance = parent::getInstance();
  //$instance = new DBAccess();
     $MySQLiconn  = $instance->getConnection();	

 $sql = "SELECT * from members";
      $statement = $MySQLiconn->prepare($sql);
  $statement->execute();

  $num = $statement->rowCount();

  return $num;
parent::DisConnect( $MySQLiconn);
}







public function getUsersPassword2($staffno) {
  $instance = parent::getInstance();	
     $MySQLiconn  = $instance->getConnection();
  
      $sql = 'SELECT *
              FROM   login
              WHERE  staffno = :staffno';

      $statement = $MySQLiconn->prepare($sql);
      $statement->bindValue(':staffno', $staffno);

      $statement->execute();
  $row = $statement->fetch(PDO::FETCH_ASSOC);

   $this->role = $row['role'];

  return $this->role;
      
    
   parent::DisConnect( $MySQLiconn);
  
  }

 public function getPassword(){
   return $this->password ;
   }
   
 public function getRole(){
   return $this->role ;
   }   



 public function updateLoginDetails($staffno,$password,$password2) {
   $instance = parent::getInstance();	
     $MySQLiconn  = $instance->getConnection();	
   
 try{
 
  //   $sql = "INSERT INTO login (staffno,password,role,email,textcode,password2)
            //  VALUES (:staffno, :password, :role, :email, :textcode, :password2)";
      
      $sql = "UPDATE login SET password = :password, password2 = :password2 WHERE staffno = :staffno";
        

     $options = array('cost' => self::BCRYPT_COST);
      $derivedPassword = password_hash($password, PASSWORD_BCRYPT, $options);
     // $derivedTexcode = md5(uniqid(rand())); 
      $statement = $MySQLiconn->prepare($sql);

      $statement->bindValue(':staffno',$staffno, PDO::PARAM_STR );
  
      $statement->bindValue(":password", $derivedPassword, PDO::PARAM_STR);
      
  
    $statement->bindValue(":password2", $password2 , PDO::PARAM_STR);
      $statement->execute();
  
  
  parent::DisConnect( $MySQLiconn);
  }

      catch(Exception $e){
    echo "oops! ".$e->getMessage(); 
    
    }   
  }



 public function updateSubjectLoginDetails($staffno,$password,$password2) {
   $instance = parent::getInstance();	
     $MySQLiconn  = $instance->getConnection();	
   
 try{
 
  //   $sql = "INSERT INTO login (staffno,password,role,email,textcode,password2)
            //  VALUES (:staffno, :password, :role, :email, :textcode, :password2)";
      
      $sql = "UPDATE subjectlogin SET password = :password, password2 = :password2 WHERE staffno = :staffno";
        

     $options = array('cost' => self::BCRYPT_COST);
      $derivedPassword = password_hash($password, PASSWORD_BCRYPT, $options);
     // $derivedTexcode = md5(uniqid(rand())); 
      $statement = $MySQLiconn->prepare($sql);

      $statement->bindValue(':staffno',$staffno, PDO::PARAM_STR );
  
      $statement->bindValue(":password", $derivedPassword, PDO::PARAM_STR);
      
  
    $statement->bindValue(":password2", $password2 , PDO::PARAM_STR);
      $statement->execute();
  
  
  parent::DisConnect( $MySQLiconn);
  }

      catch(Exception $e){
    echo "oops! ".$e->getMessage(); 
    
    }   
  }


  
    public function getUsersPasswordSubject($staffno) {
  $instance = parent::getInstance();	
     $MySQLiconn  = $instance->getConnection();
  
      $sql = 'SELECT password
              FROM   subjectlogin
              WHERE  staffno = :staffno';

      $statement = $MySQLiconn->prepare($sql);
      $statement->bindValue(':staffno', $staffno);

      $statement->execute();
      $row = $statement->fetch(PDO::FETCH_ASSOC);
      $this->password = $row['password'];

     parent::DisConnect( $MySQLiconn);

      return $this->password;
  }


public function getUsersPassword2Subject($staffno) {
  $instance = parent::getInstance();	
     $MySQLiconn  = $instance->getConnection();
  
      $sql = 'SELECT *
              FROM   subjectlogin
              WHERE  staffno = :staffno';

      $statement = $MySQLiconn->prepare($sql);
      $statement->bindValue(':staffno', $staffno);

      $statement->execute();
  $row = $statement->fetch(PDO::FETCH_ASSOC);

   $this->role = $row['role'];

  return $this->role;
      
    
   parent::DisConnect( $MySQLiconn);
  
  }



 public function createSubjectLogin($staffno,$password,$role,$email,$textcode,$password2) {
   $instance = parent::getInstance();	
     $MySQLiconn  = $instance->getConnection();	
   
 try{
 
     $sql = "INSERT INTO subjectlogin (staffno,password,role,email,textcode,password2)
              VALUES (:staffno, :password, :role, :email, :textcode, :password2)";
        

     $options = array('cost' => self::BCRYPT_COST);
      $derivedPassword = password_hash($password, PASSWORD_BCRYPT, $options);
     // $derivedTexcode = md5(uniqid(rand())); 
      $statement = $MySQLiconn->prepare($sql);

      $statement->bindValue(':staffno',$staffno, PDO::PARAM_STR );
  
      $statement->bindValue(":password", $derivedPassword, PDO::PARAM_STR);
      $statement->bindValue(":role", $role,  PDO::PARAM_STR);
  $statement->bindValue(":email", $email , PDO::PARAM_STR);
  $statement->bindValue(":textcode", $textcode , PDO::PARAM_STR);
    $statement->bindValue(":password2", $password2 , PDO::PARAM_STR);
      $statement->execute();
  
  
  parent::DisConnect( $MySQLiconn);
  }

      catch(Exception $e){
  //	echo "oops! ".$e->getMessage(); 
    
    }   
  }
  



public function checkStaffid($staffno){
  
  $instance = parent::getInstance();	
     $MySQLiconn  = $instance->getConnection();
  
      $sql = 'SELECT *
              FROM   login
              WHERE  staffno = :staffno';

      $statement = $MySQLiconn->prepare($sql);
      $statement->bindValue(':staffno', $staffno);

      $statement->execute();
  //$row = $statement->fetch(PDO::FETCH_ASSOC);
  
   
  $num = $statement->rowCount();
 

  return $num;
      
    
   parent::DisConnect( $MySQLiconn);
    
  
  } 	
  

public function deleteStaffLogin($staffno){
  
  $instance = parent::getInstance();	
     $MySQLiconn  = $instance->getConnection();
  
      $sql = 'DELETE 
              FROM   login
              WHERE  staffno = :staffno';

      $statement = $MySQLiconn->prepare($sql);
      $statement->bindValue(':staffno', $staffno);

      $statement->execute();  
    parent::DisConnect( $MySQLiconn);
  }		


public function deleteStaffSubjectLogin($staffno){
  
  $instance = parent::getInstance();	
     $MySQLiconn  = $instance->getConnection();
  
      $sql = 'DELETE 
              FROM   subjectlogin
              WHERE  staffno = :staffno';

      $statement = $MySQLiconn->prepare($sql);
      $statement->bindValue(':staffno', $staffno);

      $statement->execute();  
    parent::DisConnect( $MySQLiconn);
  }	
  
  

public function deleteVerifySubjectLogin($staffno){
  
  $instance = parent::getInstance();	
     $MySQLiconn  = $instance->getConnection();
  
      $sql = 'DELETE 
              FROM   verifysubject
              WHERE  staffno = :staffno';

      $statement = $MySQLiconn->prepare($sql);
      $statement->bindValue(':staffno', $staffno);

      $statement->execute();  
    parent::DisConnect( $MySQLiconn);
  }		


}