<?php
require_once( "dbresult.php" );

 class Students extends Dbresult {
	 
	 public $fname;
	 public $lname;
	 public $dob;
	 public $doe;
	 public $gender;
	 public $class1;
	 public $othernames;
	 public $phone;
	 public $dateadmitted;
	 public $username;
	 public $email;
	 public $admissionno;
	 public $image;
	  public $fees;
	 public $class2;
	 public $pta;
	 public $transport;
	 public $genotype;
	 public $bloodgroup;
	 public $present;
	 public $absent;
	 public $male;
	 public $female;
	 public $total;
	  public $avgmark; 
	  public $sum_mark;
	  public $subject;
	 
	 public function __construct() {

   }
	 
	 public function addStudents($fname,$lname,$dob,$doe,$gender,$class,$othernames,$phone,$dateadmitted,$username,$email,$admissionno,$bloodgroup,$genotype){
		 
		 try{
		
		
		$instance = parent::getInstance();
		// $instance = new DBAccess();
     $MySQLiconn  = $instance->getConnection();
		 
        $sql = 'INSERT INTO student (fname,lname,dob,doe,gender,class,othernames,phone,dateadmitted,username,email,admissionno,bloodgroup,genotype)
                VALUES (:fname, :lname, :dob, :doe, :gender, :class,:othernames,:phone, :dateadmitted,:username,:email,
				 :admissionno,:bloodgroup,:genotype)';

       
         
        $statement = $MySQLiconn->prepare($sql);
        $statement->bindValue(':fname', $fname);
		$statement->bindValue(':lname', $lname);
		$statement->bindValue(':dob', $dob);
		$statement->bindValue(':doe', $doe);
		$statement->bindValue(':gender', $gender);
		$statement->bindValue(':class', $class);
		$statement->bindValue(':othernames', $othernames);	
		$statement->bindValue(':phone', $phone);
		$statement->bindValue(':dateadmitted', $dateadmitted);
		$statement->bindValue(':username', $username);	
		$statement->bindValue(':email', $email);
		$statement->bindValue(':admissionno', $admissionno);
		$statement->bindValue(':bloodgroup', $bloodgroup);
		$statement->bindValue(':genotype', $genotype);
        $statement->execute();

        parent::DisConnect( $MySQLiconn);	 
			
			
			
			 
			 
			 }
			 
			 catch(Exception $e){
			echo "oops! ".$e->getMessage(); 
			
			} 
		 
		 }
		 
		 
		 
	 
	 
	 public function findAllStudents(){
		 $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
        $sql = 'SELECT *
                FROM  student';

        $statement = $MySQLiconn->prepare($sql);
       
        $statement->execute();
		
	    return $statement;
	   
		 parent::DisConnect( $MySQLiconn);  
		 
		 }
		 
		 
		 public function deleteStudent($admissionno){
			
			 $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
        $sql = 'DELETE 
                FROM   student
                WHERE  admissionno = :admissionno';

        $statement = $MySQLiconn->prepare($sql);
        $statement->bindValue(':admissionno', $admissionno);

        $statement->execute();  
		  parent::DisConnect( $MySQLiconn);
			 
			 }
			 
			 
	
	 public function updateStudents($fname,$lname,$dob,$doe,$gender,$othernames,$phone,$dateadmitted,$email,$admissionno,$bloodgroup,$genotype){
		 
		 try{
		
		
		$instance = parent::getInstance();
		// $instance = new DBAccess();
     $MySQLiconn  = $instance->getConnection();
		 
        $sql = 'UPDATE student
              set fname =  :fname, lname = :lname, dob = :dob, doe = :doe, gender = :gender, othernames = :othernames, phone = :phone, 
			 dateadmitted =  :dateadmitted,email = :email, genotype = :genotype, bloodgroup = :bloodgroup where admissionno =  :admissionno';

       
         
        $statement = $MySQLiconn->prepare($sql);
        $statement->bindValue(':fname', $fname);
		$statement->bindValue(':lname', $lname);
		$statement->bindValue(':dob', $dob);
		$statement->bindValue(':doe', $doe);
		$statement->bindValue(':gender', $gender);
		
		$statement->bindValue(':othernames', $othernames);	
		$statement->bindValue(':phone', $phone);
		$statement->bindValue(':dateadmitted', $dateadmitted);
		
		$statement->bindValue(':email', $email);
		$statement->bindValue(':admissionno', $admissionno);
		$statement->bindValue(':bloodgroup', $bloodgroup);
		$statement->bindValue(':genotype', $genotype);
        $statement->execute();

        parent::DisConnect( $MySQLiconn);	 
			
			
			
			 
			 
			 }
			 
			 catch(Exception $e){
			echo "oops! ".$e->getMessage(); 
			
			} 
		 
		 }
	 
	
	
	public function checkAdmissionNo($admissionno){
		
		$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
        $sql = 'SELECT *
                FROM   student
                WHERE  admissionno = :admissionno';

        $statement = $MySQLiconn->prepare($sql);
        $statement->bindValue(':admissionno', $admissionno);

        $statement->execute();
		//$row = $statement->fetch(PDO::FETCH_ASSOC);
		
     
	  $num = $statement->rowCount();
	 
 
    return $num;
        
      
		 parent::DisConnect( $MySQLiconn);
		
		
		
		
		}
	
	
			 
	
	public function searchStudent($name,$year){
		$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
	   
//  $res=$MySQLiconn->query("SELECT  * FROM personaldata WHERE memberid LIKE '%" . $name .  "%' OR lname LIKE '%" . $name ."%' OR fname LIKE '%" . $name ."%' OR acno LIKE '%" . $name ."%'"); 	   
		
       
				
			
	//	$sql = 	"SELECT  * FROM student WHERE admissionno LIKE '%" . $name .  "%' OR lname LIKE '%" . $name ."%' OR fname LIKE '%" . $name ."%'";
		

 $sql = "SELECT s.class,s.image, w.lname,w.fname,w.admissionno,w.gender,w.phone,w.dateadmitted,w.dob,w.doe,w.email,w.othernames,w.bloodgroup,
 w.genotype
                FROM  studentrecord s   INNER JOIN student w ON s.admissionno = w.admissionno where s.year = :year AND w.admissionno 
				 LIKE '%" . $name .  "%' OR w.lname LIKE '%" . $name ."%' OR w.fname LIKE '%" . $name ."%'  OR s.class LIKE '%" . $name ."%'
				 OR w.gender LIKE '%" . $name ."%' ";		
			
				

        $statement = $MySQLiconn->prepare($sql);
		 $statement->bindValue(':year',$year);
       
        $statement->execute();
		
	    return $statement;
	   
		 parent::DisConnect( $MySQLiconn); 
		
		
		}
		
	
	public function findStudentsByadmissionNo($admissionno,$year){
		$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
	   
	    $sql = 'SELECT s.class,s.class2,s.image, w.lname,w.fname,w.admissionno,w.gender,w.phone,w.dateadmitted,w.dob,w.doe,w.email,w.bloodgroup,w.genotype,w.othernames
                FROM  studentrecord s   INNER JOIN student w ON s.admissionno = w.admissionno where s.year = :year AND w.admissionno =:admissionno';
	   
	   
	    $statement = $MySQLiconn->prepare($sql);
		
		$statement->bindValue(':admissionno',$admissionno);
		$statement->bindValue(':year',$year);
	    $statement->execute();
	   $row = $statement->fetch(PDO::FETCH_ASSOC);
	   
	   $this->admissionno = $row['admissionno'];
	   $this->class1=$row['class'];
	   $this->gender = $row['gender'];
	   $this->dateadmitted = $row['dateadmitted'];
	   $this->lname = $row['lname'];
	   $this->fname = $row['fname'];
	   $this->dob = $row['dob'];
	   $this->doe = $row['doe'];
	   $this->email = $row['email'];
	   $this->image = $row['image'];
	   $this->phone = $row['phone'];
	   $this->genotype = $row['genotype'];
	   $this->bloodgroup = $row['bloodgroup'];
	   $this->othernames = $row['othernames'];
           $this->class2 = $row['class2'];
		
		 parent::DisConnect( $MySQLiconn); 
		
		}
	
	 public function findOneStudentsByadmissionNo($admissionno){
		$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
	   
	    $sql = 'SELECT * from student WHERE admissionno =:admissionno';
	   
	   
	    $statement = $MySQLiconn->prepare($sql);
		
		$statement->bindValue(':admissionno',$admissionno);
		
	    $statement->execute();
	   $row = $statement->fetch(PDO::FETCH_ASSOC);
	   
	   $this->admissionno = $row['admissionno'];
	  // $this->class1=$row['class'];
	   $this->gender = $row['gender'];
	   $this->dateadmitted = $row['dateadmitted'];
	   $this->lname = $row['lname'];
	   $this->fname = $row['fname'];
	   $this->dob = $row['dob'];
	   $this->doe = $row['doe'];
	   $this->email = $row['email'];
	 
	   $this->phone = $row['phone'];
	   $this->fees = $row['fees'];
	   $this->transport = $row['transport'];
		$this->image = $row['image'];
		 parent::DisConnect( $MySQLiconn); 
		
		}
	
	
	 
	  public function findOneStudentsByadmissionNoSession1($admissionno,$session1){
		$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
	   
	    $sql = 'SELECT * from studentrecord WHERE admissionno =:admissionno AND  session1 = :session1';
	   
	   
	    $statement = $MySQLiconn->prepare($sql);
		
		$statement->bindValue(':admissionno',$admissionno);
		$statement->bindValue(':session1',$session1);
		
	    $statement->execute();
	   $row = $statement->fetch(PDO::FETCH_ASSOC);
	   
	   $this->admissionno = $row['admissionno'];
	  $this->class1=$row['class'];
	   
		
		 parent::DisConnect( $MySQLiconn); 
		
		}
	
	public function addDebtors($admissionno,$fees){
		$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
	   
	   $sql = 'update student set fees = :fees WHERE admissionno = :admissionno';
	   $statement = $MySQLiconn->prepare($sql);
	   $statement->bindValue(':admissionno',$admissionno);
		$statement->bindValue(':fees',$fees);
		
	    $statement->execute();
		 parent::DisConnect( $MySQLiconn);
		
		}
		
	
 public function updateFeesWithStatus($admissionno,$fees,$studstatus){
	  $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
	   
	   $sql = 'UPDATE student set fees = :fees, studstatus = :studstatus where admissionno = :admissionno';
	   
	   $statement = $MySQLiconn->prepare($sql);
		
		$statement->bindValue(':admissionno',$admissionno);
		$statement->bindValue(':fees',$fees);
		$statement->bindValue(':studstatus',$studstatus);
	    $statement->execute();
	   
	    parent::DisConnect( $MySQLiconn);  
	   }
	   
	   
	    public function findAllDefaulters(){
		 $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
        $sql = 'SELECT *
                FROM  student WHERE fees > 0';

        $statement = $MySQLiconn->prepare($sql);
       
        $statement->execute();
		
	    return $statement;
	   
		 parent::DisConnect( $MySQLiconn);  
		 
		 }
		 
		 
		  public function findAllDefaultersByClass($class){
		 $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
        $sql = 'SELECT *
                FROM  student WHERE fees > 0 and class = :class';

        $statement = $MySQLiconn->prepare($sql);
		$statement->bindValue(':class',$class);
       
        $statement->execute();
		
	    return $statement;
	   
		 parent::DisConnect( $MySQLiconn);  
		 
		 }


        
           public function updateTransport($admissionno, $transport){
			 
			 $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
	   
	      
		  $sql = "UPDATE student SET transport = :transport WHERE admissionno = :admissionno";
		  
		   $statement = $MySQLiconn->prepare($sql);
		$statement->bindValue(':admissionno',$admissionno);
		$statement->bindValue(':transport',$transport);
       
        $statement->execute();
		
	   
	   
		 parent::DisConnect( $MySQLiconn);  
		  
		  
		  
			 
			 }
		 
			 		 
	 
	 public function searchStudentAll($name){
		$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
	   


 $sql = "SELECT class,image, lname,fname,admissionno,gender,phone,dateadmitted,dob,doe,email
                FROM  student  where admissionno 
				 LIKE '%" . $name .  "%' OR lname LIKE '%" . $name ."%' OR fname LIKE '%" . $name ."%'  OR class LIKE '%" . $name ."%'";		
			
				

        $statement = $MySQLiconn->prepare($sql);
		
       
        $statement->execute();
		
	    return $statement;
	   
		 parent::DisConnect( $MySQLiconn); 
		
		
		}
				 		 


 public function findOneStudentsByadmissionNo2($admissionno){
		$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
	   
	    $sql = 'SELECT * from student WHERE admissionno =:admissionno';
	   
	   
	    $statement = $MySQLiconn->prepare($sql);
		
		$statement->bindValue(':admissionno',$admissionno);
		
	    $statement->execute();
	   $row = $statement->fetch(PDO::FETCH_ASSOC);
	   
	   $this->admissionno = $row['admissionno'];
	   $this->class1=$row['class'];
	   $this->gender = $row['gender'];
	   $this->dateadmitted = $row['dateadmitted'];
	   $this->lname = $row['lname'];
	   $this->fname = $row['fname'];
	   $this->dob = $row['dob'];
	   $this->doe = $row['doe'];
	   $this->email = $row['email'];
             $this->fees = $row['fees'];
	        // $this->transport = $row['transport'];
	   $this->phone = $row['phone'];
	   $this->othernames = $row['othernames'];
		
		 parent::DisConnect( $MySQLiconn); 
		
		}
		
	
	 public function updateStudentImage($admissionno, $image){
			 
			 $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
	   
	      
		  $sql = "UPDATE student SET image = :image WHERE admissionno = :admissionno";
		  
		   $statement = $MySQLiconn->prepare($sql);
		$statement->bindValue(':admissionno',$admissionno);
		$statement->bindValue(':image',$image);
       
        $statement->execute();
		
	   
	   
		 parent::DisConnect( $MySQLiconn);  
		  
		  
		  
			 
			 }
			 
			 
	
	  public function updateFees($admissionno,$fees){
	  $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
	   
	   $sql = 'UPDATE student set fees = :fees where admissionno = :admissionno';
	   
	   $statement = $MySQLiconn->prepare($sql);
		
		$statement->bindValue(':admissionno',$admissionno);
		$statement->bindValue(':fees',$fees);
		
	    $statement->execute();
	   
	    parent::DisConnect( $MySQLiconn);  
	   }		 
	 
	 // new codes
	 
	 public function addAttendance($id,$class,$day,$date,$present,$staffid,$admissionno,$term,$session1,$year,$gender){
		    $instance = parent::getInstance();
		$MYSQLiconn = $instance->getConnection();
		 
		 $sql = 'INSERT into attendance (id,class,day,date,present,staffid,admissionno,term,session1,year,gender) VALUES (:id,:class,:day,:date,:present,:staffid,:admissionno,:term,:session1,:year,:gender)';
		 
		 
		 try{
			$statement = $MYSQLiconn->prepare($sql);
			$statement->bindValue(':id',$id);
			$statement->bindValue(':class',$class);
			$statement->bindValue(':day',$day);
			$statement->bindValue(':date',$date);
			$statement->bindValue(':present',$present);
	
			$statement->bindValue(':staffid',$staffid);
			
			$statement->bindValue(':admissionno',$admissionno);
			$statement->bindValue(':term',$term);
			$statement->bindValue(':session1',$session1);
			$statement->bindValue(':year',$year);
			$statement->bindValue(':gender',$gender);
			$statement->execute();
			parent::DisConnect();
			}
			
			 catch(Exception $e){
			echo "oops! ".$e->getMessage(); 
			
			} 
		 
		
		
		   }
		   
		   
		   
		   
		    public function updateAttendance($id,$present){
	  $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
	   
	   $sql = 'UPDATE attendance set present = :present  where id = :id';
	   
	   $statement = $MySQLiconn->prepare($sql);
		
		$statement->bindValue(':id',$id);
		$statement->bindValue(':present',$present);
		
	    $statement->execute();
	   
	    parent::DisConnect( $MySQLiconn);  
	   }	
		   	
	 
	 
	public function getAttendanceByclass($class,$date){
		 $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
        $sql = 'SELECT *
                FROM  attendance WHERE class = :class   and date= :date';

        $statement = $MySQLiconn->prepare($sql);
		$statement->bindValue(':class',$class);
        $statement->bindValue(':date',$date);
        $statement->execute();
		
	    return $statement;
	   
		 parent::DisConnect( $MySQLiconn);  
		 
		 }   
	 
	 
	
	 
	 
	  
	  public function getAttendanceByDate($date){
		 $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
        $sql = 'SELECT *
                FROM  attendance WHERE  date = :date';

        $statement = $MySQLiconn->prepare($sql);
	
        $statement->bindValue(':date',$date);
        $statement->execute();
		
	    return $statement;
	   
		 parent::DisConnect( $MySQLiconn);  
		 
		 }   
	 
	 
	 
	  
	  public function getAttendanceByAdmissionAndTerm($admissionno,$term){
		 $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
        $sql = 'SELECT *
                FROM  attendance WHERE  term = :term and admissionno = :admissionno ';

        $statement = $MySQLiconn->prepare($sql);
	
        $statement->bindValue(':admissionno',$admission);
		 $statement->bindValue(':term',$term);
        $statement->execute();
		
	    return $statement;
	   
		 parent::DisConnect( $MySQLiconn);  
		 
		 } 
		 
		 
		 public function addTotalAttendance($id,$class,$date,$total,$term,$session1,$year,$male,$female,$present,$absent){
		    $instance = parent::getInstance();
		$MYSQLiconn = $instance->getConnection();
		 
		 $sql = 'INSERT into tattendance (id,class,date,total, term, session1, year, male, female,present,absent ) VALUES (:id,:class,:date,
		 :total,:term,:session1,:year,:male,:female,:present,:absent)';
		 
		 
		 try{
			$statement = $MYSQLiconn->prepare($sql);
			$statement->bindValue(':id',$id);
			$statement->bindValue(':class',$class);
			$statement->bindValue(':date',$date);
		$statement->bindValue(':total',$total);
		$statement->bindValue(':term',$term);
			$statement->bindValue(':session1',$session1);
			$statement->bindValue(':year',$year);
			$statement->bindValue(':male',$male);
			$statement->bindValue(':female',$female);
			$statement->bindValue(':present',$present);
	        $statement->bindValue(':absent',$absent);
			
			
		
			$statement->execute();
			parent::DisConnect();
			}
			
			 catch(Exception $e){
			echo "oops! ".$e->getMessage(); 
			
			} 
		 
		
		
		   }
		   
		   
	
	
	     public function updateTotalAttendance($id,$present,$total,$male,$female,$absent){
	  $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
	   
	   $sql = 'UPDATE tattendance set present = :present,total = :total, male = :male, female = :female, absent = :absent    where id = :id';
	   
	   $statement = $MySQLiconn->prepare($sql);
		
		$statement->bindValue(':id',$id);
		$statement->bindValue(':present',$present);
			$statement->bindValue(':total',$total);
		$statement->bindValue(':male',$male);
			$statement->bindValue(':female',$female);
		
	        $statement->bindValue(':absent',$absent);
	    $statement->execute();
	   
	    parent::DisConnect( $MySQLiconn);  
	   }	
	   
	   
	   	  
		  
	
	   public function getAttendanceByClassAndDate($class,$date){
		$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
	   
	    $sql = 'SELECT * from tattendance  WHERE class = :class and date = :date';
	   
	   
	    $statement = $MySQLiconn->prepare($sql);
		
		$statement->bindValue(':class',$class);
		$statement->bindValue(':date',$date);
	    $statement->execute();
	   $row = $statement->fetch(PDO::FETCH_ASSOC);
	   
	   $this->present = $row['present'];
	  
	   $this->total = $row['total'];
	   $this->absent = $row['absent'];
	   $this->doe = $row['date'];
	   $this->male = $row['male'];
	   $this->female = $row['female'];
	   
		 parent::DisConnect( $MySQLiconn); 
		
		}
		
		
		
		  public function getTotalAttendanceByDate($date){
		 $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
        $sql = 'SELECT *
                FROM  tattendance WHERE  date = :date';

        $statement = $MySQLiconn->prepare($sql);
	
        $statement->bindValue(':date',$date);
		
        $statement->execute();
		
	    return $statement;
	   
		 parent::DisConnect( $MySQLiconn);  
		 
		 } 
	
		  
		
		 public function getTotalAttendanceByDateAttendance($date){
		 $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
        $sql = 'SELECT *
                FROM  attendance WHERE  date = :date';

        $statement = $MySQLiconn->prepare($sql);
	
        $statement->bindValue(':date',$date);
		
        $statement->execute();
		
	    return $statement;
	   
		 parent::DisConnect( $MySQLiconn);  
		 
		 } 
		
		
		public function selectAvgAttendanceByClass($class,$date1,$date2){
	$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
		$sql = " select AVG(present) as avg_mark from tattendance WHERE class = :class AND  date BETWEEN '".$date1."' AND '".$date2."'  ";
		
		 
		 $statement = $MySQLiconn->prepare($sql);
		
		   $statement->bindValue(':class', $class);
        $statement->execute();
		$row = $statement->fetch(PDO::FETCH_ASSOC);
		$this->avgmark = $row['avg_mark'];
	 
		
		 parent::DisConnect( $MySQLiconn);
		}
		   
	
	
	public function selectAvgAttendanceByDate($date1,$date2){
	$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
		$sql = " select AVG(present) as avg_mark, SUM(total) as sum_mark from tattendance WHERE   date  BETWEEN '".$date1."' AND '".$date2."'  ";
		
		 
		 $statement = $MySQLiconn->prepare($sql);
		
		  
        $statement->execute();
		$row = $statement->fetch(PDO::FETCH_ASSOC);
		$this->avgmark = $row['avg_mark'];
		$this->sum_mark = $row['sum_mark'];
	 
		
		 parent::DisConnect( $MySQLiconn);
		}
		
		
		
		public function selectAvgAttendanceBetweenDates($date){
	$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
		$sql = " select AVG(present) as avg_mark, SUM(total) as sum_mark from tattendance WHERE   date = :date  ";
		
		 
		 $statement = $MySQLiconn->prepare($sql);
		
		   $statement->bindValue(':date', $date);
        $statement->execute();
		$row = $statement->fetch(PDO::FETCH_ASSOC);
		$this->avgmark = $row['avg_mark'];
		$this->sum_mark = $row['sum_mark'];
	 
		
		 parent::DisConnect( $MySQLiconn);
		}   
	 
	 
	 public function selectAvgAttendanceByDates2($date){
	$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
		$sql = " select AVG(present) as avg_mark, SUM(total) as sum_mark from tattendance WHERE   date = :date  ";
		
		 
		 $statement = $MySQLiconn->prepare($sql);
		
		   $statement->bindValue(':date', $date);
        $statement->execute();
		$row = $statement->fetch(PDO::FETCH_ASSOC);
		$this->avgmark = $row['avg_mark'];
		$this->sum_mark = $row['sum_mark'];
	 
		
		 parent::DisConnect( $MySQLiconn);
		}   
		
		//CODES FOR GRAPHICAL REPRESENTATIONS
		
		
		 public function selectGetAverageMarkForSubjectsJSS1($class2,$year,$term,$subject){
	$instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
		$sql = " select AVG(total) as avg_mark, class2,subject from scores  WHERE   class2 = :class2 AND year = :year AND  term = :term 
		AND subject = :subject  ";
		
		 
		 $statement = $MySQLiconn->prepare($sql);
		
		   $statement->bindValue(':class2', $class2);
		    $statement->bindValue(':year', $year);
			$statement->bindValue(':term', $term);
			$statement->bindValue(':subject', $subject);
        $statement->execute();
		$row = $statement->fetch(PDO::FETCH_ASSOC);
		$this->avgmark = $row['avg_mark'];
		$this->class2 = $row['class2'];
		$this->subject = $row['subject'];
		
	 
		
		 parent::DisConnect( $MySQLiconn);
		} 
		
	 
	
	
		 public function selectGetAverageMarkForSubjectsJSS11($class2,$year,$term,$subject){
		 $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
       $sql = " select AVG(total) as avg_mark, class2 from scores  WHERE   class2 = :class2 AND year = :year AND  term = :term 
		AND subject = :subject  ";
        $statement = $MySQLiconn->prepare($sql);
	
        $statement->bindValue(':class2', $class2);
		    $statement->bindValue(':year', $year);
			$statement->bindValue(':term', $term);
			$statement->bindValue(':subject', $subject);
		
        $statement->execute();
		
	    return $statement;
	   
		 parent::DisConnect( $MySQLiconn);  
		 
		 } 
	 
	 
	 
	 public function selectGetAverageMarkForMasterJunior($class2,$year,$term){
		 $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
       $sql = " select AVG(avg) as avg_mark, class2 from masterjuniortotal  WHERE   class2 = :class2 AND year = :year AND  term = :term 
		AND avg > 0  ";
        $statement = $MySQLiconn->prepare($sql);
	
        $statement->bindValue(':class2', $class2);
		    $statement->bindValue(':year', $year);
			$statement->bindValue(':term', $term);
			
		
        $statement->execute();
		
	    return $statement;
	   
		 parent::DisConnect( $MySQLiconn);  
		 
		 } 
	 
	 
	
	
		 public function selectGetAverageMarkForMasterSenior($class2,$year,$term){
		 $instance = parent::getInstance();	
       $MySQLiconn  = $instance->getConnection();
		
       $sql = " select AVG(avg) as avg_mark, class2 from mastersenior  WHERE   class2 = :class2 AND year = :year AND  term = :term 
		AND avg > 0  ";
        $statement = $MySQLiconn->prepare($sql);
	
        $statement->bindValue(':class2', $class2);
		    $statement->bindValue(':year', $year);
			$statement->bindValue(':term', $term);
			
		
        $statement->execute();
		
	    return $statement;
	   
		 parent::DisConnect( $MySQLiconn);  
		 
		 }  
	 
	 
	
	public function findCurrentPortalValues($id){
			
		$instance = parent::getInstance();	
   $MySQLiconn  = $instance->getConnection();
		
		try {
		$sql = "SELECT * from portal WHERE id =:id";
		
		$statement = $MySQLiconn->prepare($sql);
		
		$statement->bindValue(':id',$id);
		 $statement->execute();
	  $row = $statement->fetch(PDO::FETCH_ASSOC);  
	  $this->term = $row['term'];
	  $this->session = $row['session'];
	  $this->staffid = $row['staffid'];
	  $this->date = $row['date'];
		parent::DisConnect( $MySQLiconn);	

		}
		catch(Exception $e){
			echo "oops! ".$e->getMessage(); 
			
			} 

		}	

	 
	 
	 }


 ?>